(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     24711,        681]
NotebookOptionsPosition[     21212,        620]
NotebookOutlinePosition[     21645,        637]
CellTagsIndexPosition[     21602,        634]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Matriz diagonal:", "Text",
 CellChangeTimes->{{3.9010275972200193`*^9, 
  3.901027604706363*^9}},ExpressionUUID->"d38b934f-ba99-4cbf-9714-\
cb44e864c00c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"A", "=", 
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0", ",", 
     RowBox[{"Pi", "/", "3"}], ",", 
     RowBox[{"-", 
      FractionBox["5", "2"]}], ",", "7"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "A", "]"}]}], "Input",
 CellChangeTimes->{{3.9010275578736935`*^9, 3.9010275955731087`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"530df297-f06a-48a6-974b-e3c4c41e5c28"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     FractionBox["\[Pi]", "3"], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", 
      FractionBox["5", "2"]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "7"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9010275831160154`*^9, 3.9010277349532924`*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"ef7990dc-126d-4f36-beb1-c76c977c618b"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "2"}], "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", 
      FractionBox["\[Pi]", "3"], "0", "0"},
     {"0", "0", "0", 
      RowBox[{"-", 
       FractionBox["5", "2"]}], "0"},
     {"0", "0", "0", "0", "7"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.9010275831160154`*^9, 3.901027734966793*^9},
 CellLabel->
  "Out[18]//MatrixForm=",ExpressionUUID->"a6c883c7-1443-4f8a-8857-\
04b37c902dd5"]
}, Open  ]],

Cell["Matriz nula:", "Text",
 CellChangeTimes->{{3.9010275972200193`*^9, 3.901027604706363*^9}, {
  3.9010294090016117`*^9, 
  3.9010294094655237`*^9}},ExpressionUUID->"085971bf-e40f-41d6-9cef-\
f10f326bd968"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"B", "=", 
  RowBox[{"DiagonalMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "B", "]"}]}], "Input",
 CellChangeTimes->{{3.949065043806567*^9, 3.9490650548654327`*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"c7f8bafa-3858-45c4-8666-1b809b471e0d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.9490650557968273`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"cd109dd3-7819-48d3-9b9d-feb59034e2cd"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.949065055797773*^9},
 CellLabel->
  "Out[32]//MatrixForm=",ExpressionUUID->"3986a31a-b7cb-47dd-992d-\
c86d161f44c7"]
}, Open  ]],

Cell["o bien:", "Text",
 CellChangeTimes->{{3.9010275972200193`*^9, 3.901027604706363*^9}, {
  3.9010294090016117`*^9, 3.9010294094655237`*^9}, {3.949065069182866*^9, 
  3.94906506989577*^9}},ExpressionUUID->"80f169f7-73d0-4dae-bc75-\
b386158e12a7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"B", "=", 
  RowBox[{"ConstantArray", "[", 
   RowBox[{"0", ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"B", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.901029411779372*^9, 3.901029441762906*^9}},
 CellLabel->"In[68]:=",ExpressionUUID->"714cf738-d8b4-4c15-b929-ac53865806f6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.901029430709526*^9, 3.9010294427402067`*^9}},
 CellLabel->"Out[68]=",ExpressionUUID->"828fcfa6-4be7-4fbf-9863-4e87c1d9ea2e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"},
     {"0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.901029430709526*^9, 3.9010294427402067`*^9}},
 CellLabel->
  "Out[69]//MatrixForm=",ExpressionUUID->"f8797efe-c357-495c-bd87-\
a058baecaeda"]
}, Open  ]],

Cell["Matriz triangular superior:", "Text",
 CellChangeTimes->{{3.9010275972200193`*^9, 
  3.901027615807605*^9}},ExpressionUUID->"ef29fe43-7d0d-4001-a2bf-\
a9401aea91f0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"c", "=", 
  RowBox[{"UpperTriangularize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "7"}], ",", 
        RowBox[{"-", "3"}], ",", 
        RowBox[{"-", "7"}], ",", 
        RowBox[{
         RowBox[{"-", "7"}], "/", "10"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "6"}], ",", 
        RowBox[{"5", "/", "2"}], ",", 
        RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", 
        RowBox[{
         RowBox[{"-", "9"}], "/", "8"}], ",", 
        RowBox[{"-", "9"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", 
        RowBox[{"-", "E"}], ",", 
        RowBox[{"5", "/", "3"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
        RowBox[{"4", "/", "9"}]}], "}"}]}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{"0", "->", "1"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "c", "]"}]}], "Input",
 CellChangeTimes->{{3.901027749773128*^9, 3.901027814155262*^9}, {
  3.901027863327435*^9, 3.9010279129524775`*^9}, {3.901028220281742*^9, 
  3.9010282334416685`*^9}, {3.901028280564866*^9, 3.9010283168483005`*^9}, {
  3.949062347993814*^9, 3.949062380794506*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"8b2bcac9-7a69-4a10-8f5b-28475aedf830"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", 
      FractionBox["7", "10"]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "6"}], ",", 
     FractionBox["5", "2"], ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", 
     RowBox[{"-", 
      FractionBox["9", "8"]}], ",", 
     RowBox[{"-", "9"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "\[ExponentialE]"}], ",", 
     FractionBox["5", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
     FractionBox["4", "9"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9010282815230207`*^9, 3.901028290626791*^9}, 
   3.9010283506864433`*^9, {3.9490623562752447`*^9, 3.9490623840410213`*^9}, 
   3.9490624360958643`*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"3aa25243-e5a5-46f7-8354-a31ef876e3a5"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "7"}], 
      RowBox[{"-", "3"}], 
      RowBox[{"-", "7"}], 
      RowBox[{"-", 
       FractionBox["7", "10"]}], "1"},
     {"0", 
      RowBox[{"-", "6"}], 
      FractionBox["5", "2"], 
      RowBox[{"-", "1"}], "2"},
     {"0", "0", "1", 
      RowBox[{"-", 
       FractionBox["9", "8"]}], 
      RowBox[{"-", "9"}]},
     {"0", "0", "0", 
      RowBox[{"-", "\[ExponentialE]"}], 
      FractionBox["5", "3"]},
     {"0", "0", "0", "0", 
      FractionBox["4", "9"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.9010282815230207`*^9, 3.901028290626791*^9}, 
   3.9010283506864433`*^9, {3.9490623562752447`*^9, 3.9490623840410213`*^9}, 
   3.9490624360968313`*^9},
 CellLabel->
  "Out[22]//MatrixForm=",ExpressionUUID->"7aef8bea-8559-4c68-af23-\
2cd5ba7f3751"]
}, Open  ]],

Cell["Matriz triangular inferior:", "Text",
 CellChangeTimes->{{3.9010275972200193`*^9, 3.901027615807605*^9}, {
  3.9010277661363134`*^9, 
  3.901027769766595*^9}},ExpressionUUID->"136239ce-b573-4515-addd-\
947e410d1ac7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"d", "=", 
  RowBox[{"LowerTriangularize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"9", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"-", "10"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "4"}], ",", 
        RowBox[{"-", "7"}], ",", 
        RowBox[{
         RowBox[{"-", "8"}], "/", "3"}], ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", 
        RowBox[{"-", "2"}], ",", "9", ",", 
        RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", 
        RowBox[{"-", "9"}], ",", "6", ",", "6", ",", 
        RowBox[{"-", "6"}]}], "}"}]}], "}"}], "/.", 
    RowBox[{"{", 
     RowBox[{"0", "->", "1"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "d", "]"}]}], "Input",
 CellChangeTimes->{{3.901027749773128*^9, 3.901027814155262*^9}, {
  3.901027863327435*^9, 3.9010279129524775`*^9}, {3.901028220281742*^9, 
  3.9010282334416685`*^9}, {3.901028280564866*^9, 3.9010283168483005`*^9}, {
  3.90102837573193*^9, 3.9010284335437107`*^9}, {3.949062391167601*^9, 
  3.949062394306584*^9}, {3.9490626157915993`*^9, 3.9490626181595917`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"0da639f1-867b-4896-9d54-cfb1da0e590c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", 
     RowBox[{"-", "10"}], ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "4"], ",", 
     RowBox[{"-", "7"}], ",", 
     RowBox[{"-", 
      FractionBox["8", "3"]}], ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     RowBox[{"-", "2"}], ",", "9", ",", 
     FractionBox["1", "2"], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "9"}], ",", "6", ",", "6", ",", 
     RowBox[{"-", "6"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.901028455186305*^9, 3.949062432112645*^9, 
  3.949062635159604*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"082310a5-3641-472b-9969-b20f09757990"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"9", "0", "0", "0", "0"},
     {"5", 
      RowBox[{"-", "10"}], "0", "0", "0"},
     {
      FractionBox["1", "4"], 
      RowBox[{"-", "7"}], 
      RowBox[{"-", 
       FractionBox["8", "3"]}], "0", "0"},
     {"6", 
      RowBox[{"-", "2"}], "9", 
      FractionBox["1", "2"], "0"},
     {
      RowBox[{"-", "2"}], 
      RowBox[{"-", "9"}], "6", "6", 
      RowBox[{"-", "6"}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.901028455186305*^9, 3.949062432112645*^9, 
  3.9490626351606073`*^9},
 CellLabel->
  "Out[24]//MatrixForm=",ExpressionUUID->"5e2f157f-16e9-40ac-a80c-\
76c7c0316383"]
}, Open  ]],

Cell["Matriz sim\[EAcute]trica:", "Text",
 CellChangeTimes->{{3.9010275972200193`*^9, 3.901027615807605*^9}, {
   3.9010277661363134`*^9, 3.901027769766595*^9}, {3.9010284726811886`*^9, 
   3.9010284780831165`*^9}, 
   3.901028586152162*^9},ExpressionUUID->"6b4ed127-3fa1-4fcb-8b47-\
a903aa1aad12"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"6", 
       RowBox[{"-", "4"}], 
       RowBox[{"-", "3"}], 
       RowBox[{"-", "3"}], 
       RowBox[{"-", "9"}]},
      {
       RowBox[{"-", "4"}], "0", 
       RowBox[{"-", "1"}], "4", 
       RowBox[{"3", "/", "5"}]},
      {
       RowBox[{"-", "3"}], 
       RowBox[{"-", "1"}], 
       RowBox[{"1", "/", "3"}], 
       RowBox[{"-", "2"}], "5"},
      {
       RowBox[{"-", "3"}], "4", 
       RowBox[{"-", "2"}], "4", 
       RowBox[{"-", "3"}]},
      {
       RowBox[{"-", "9"}], 
       RowBox[{"3", "/", "5"}], "5", 
       RowBox[{"-", "3"}], "0"}
     }], "\[NoBreak]", ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"e", "==", 
  RowBox[{"Transpose", "[", "e", "]"}]}]}], "Input",
 CellChangeTimes->{{3.901027749773128*^9, 3.901027814155262*^9}, {
  3.901027863327435*^9, 3.9010279129524775`*^9}, {3.901028220281742*^9, 
  3.9010282334416685`*^9}, {3.901028280564866*^9, 3.9010283168483005`*^9}, {
  3.90102837573193*^9, 3.9010284335437107`*^9}, {3.901028481831641*^9, 
  3.901028578351472*^9}, {3.9010286859609823`*^9, 3.901028694622864*^9}, {
  3.949062399529251*^9, 3.949062404825288*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"3e7e01ea-1e00-44e8-b9a2-42592e803396"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.901028567499473*^9, 3.901028579051365*^9}, 
   3.901028738357904*^9, 3.94906240577463*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"df52c598-8b29-4b4d-a9d4-e9502d6471b6"]
}, Open  ]],

Cell["Matriz antisim\[EAcute]trica:", "Text",
 CellChangeTimes->{{3.9010275972200193`*^9, 3.901027615807605*^9}, {
  3.9010277661363134`*^9, 3.901027769766595*^9}, {3.9010284726811886`*^9, 
  3.9010284780831165`*^9}, {3.901028586152162*^9, 
  3.901028606153146*^9}},ExpressionUUID->"26eaf4a8-f1aa-4900-9842-\
d254d99184f6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", 
       RowBox[{"-", "3"}], 
       RowBox[{"-", "5"}], 
       RowBox[{"-", "10"}], 
       RowBox[{"-", "5"}]},
      {"3", "0", "10", 
       RowBox[{"-", "4"}], 
       RowBox[{"-", "2"}]},
      {"5", 
       RowBox[{"-", "10"}], "0", "6", 
       RowBox[{"-", "5"}]},
      {"10", "4", 
       RowBox[{"-", "6"}], "0", 
       RowBox[{"-", "10"}]},
      {"5", "2", "5", "10", "0"}
     }], "\[NoBreak]", ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Transpose", "[", "F", "]"}], "==", 
  RowBox[{"-", "F"}]}]}], "Input",
 CellChangeTimes->{{3.901027749773128*^9, 3.901027814155262*^9}, {
   3.901027863327435*^9, 3.9010279129524775`*^9}, {3.901028220281742*^9, 
   3.9010282334416685`*^9}, {3.901028280564866*^9, 3.9010283168483005`*^9}, {
   3.90102837573193*^9, 3.9010284335437107`*^9}, {3.901028481831641*^9, 
   3.901028578351472*^9}, {3.901028610388527*^9, 3.9010286223412757`*^9}, {
   3.9010287480460467`*^9, 3.9010287952506905`*^9}, 3.9010288410305214`*^9, 
   3.9010288742107544`*^9, {3.9490624104479923`*^9, 
   3.94906241547742*^9}},ExpressionUUID->"460613fe-d951-4ec4-85ae-\
0a368a9a1056"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9010287876605773`*^9, 3.9010288250374737`*^9}, {
  3.901028883967832*^9, 3.9010289035342875`*^9}},
 CellLabel->"Out[47]=",ExpressionUUID->"cdfb30ed-f316-4894-a261-01add74cf880"]
}, Open  ]],

Cell["Matriz identidad y escalar:", "Text",
 CellChangeTimes->{{3.9010275972200193`*^9, 3.901027615807605*^9}, {
  3.9010277661363134`*^9, 3.901027769766595*^9}, {3.9010284726811886`*^9, 
  3.9010284780831165`*^9}, {3.901028586152162*^9, 3.901028606153146*^9}, {
  3.901029132574583*^9, 
  3.9010291401640997`*^9}},ExpressionUUID->"399d331f-a36d-4c07-9b72-\
2f38b24c9ea6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"IdentityMatrix", "[", "5", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "%", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"5", 
   RowBox[{"IdentityMatrix", "[", "5", "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.901029142491982*^9, 3.901029172030086*^9}},
 CellLabel->"In[64]:=",ExpressionUUID->"9811b81d-11d0-4883-a3f1-69b2f4efddbb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.901029148110073*^9, 3.9010291733235765`*^9}},
 CellLabel->"Out[64]=",ExpressionUUID->"f0cb0176-ad39-4e54-9a39-c3901e3b91d3"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0", "0"},
     {"0", "1", "0", "0", "0"},
     {"0", "0", "1", "0", "0"},
     {"0", "0", "0", "1", "0"},
     {"0", "0", "0", "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.901029148110073*^9, 3.901029173332185*^9}},
 CellLabel->
  "Out[65]//MatrixForm=",ExpressionUUID->"d8b1725e-2534-4354-9680-\
0c96d805f9d1"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"5", "0", "0", "0", "0"},
     {"0", "5", "0", "0", "0"},
     {"0", "0", "5", "0", "0"},
     {"0", "0", "0", "5", "0"},
     {"0", "0", "0", "0", "5"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.901029148110073*^9, 3.901029173332185*^9}},
 CellLabel->
  "Out[66]//MatrixForm=",ExpressionUUID->"9ce3d172-5267-4918-a00a-\
7b64a3d56f7b"]
}, Open  ]]
},
WindowSize->{991, 471},
WindowMargins->{{-1527, Automatic}, {Automatic, 129}},
Magnification:>1.25 Inherited,
FrontEndVersion->"14.2 para Mac OS X ARM (64-bit) (December 26, 2024)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"1c69d1c8-4835-4f00-bba6-0761d27056d4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 160, 3, 84, "Text",ExpressionUUID->"d38b934f-ba99-4cbf-9714-cb44e864c00c"],
Cell[CellGroupData[{
Cell[743, 27, 478, 11, 230, "Input",ExpressionUUID->"530df297-f06a-48a6-974b-e3c4c41e5c28"],
Cell[1224, 40, 743, 19, 244, "Output",ExpressionUUID->"ef7990dc-126d-4f36-beb1-c76c977c618b"],
Cell[1970, 61, 869, 26, 301, "Output",ExpressionUUID->"a6c883c7-1443-4f8a-8857-04b37c902dd5"]
}, Open  ]],
Cell[2854, 90, 209, 4, 84, "Text",ExpressionUUID->"085971bf-e40f-41d6-9cef-f10f326bd968"],
Cell[CellGroupData[{
Cell[3088, 98, 382, 7, 194, "Input",ExpressionUUID->"c7f8bafa-3858-45c4-8666-1b809b471e0d"],
Cell[3473, 107, 624, 15, 185, "Output",ExpressionUUID->"cd109dd3-7819-48d3-9b9d-feb59034e2cd"],
Cell[4100, 124, 746, 22, 278, "Output",ExpressionUUID->"3986a31a-b7cb-47dd-992d-c86d161f44c7"]
}, Open  ]],
Cell[4861, 149, 249, 4, 84, "Text",ExpressionUUID->"80f169f7-73d0-4dae-bc75-b386158e12a7"],
Cell[CellGroupData[{
Cell[5135, 157, 371, 8, 194, "Input",ExpressionUUID->"714cf738-d8b4-4c15-b929-ac53865806f6"],
Cell[5509, 167, 648, 15, 185, "Output",ExpressionUUID->"828fcfa6-4be7-4fbf-9863-4e87c1d9ea2e"],
Cell[6160, 184, 772, 22, 278, "Output",ExpressionUUID->"f8797efe-c357-495c-bd87-a058baecaeda"]
}, Open  ]],
Cell[6947, 209, 171, 3, 84, "Text",ExpressionUUID->"ef29fe43-7d0d-4001-a2bf-a9401aea91f0"],
Cell[CellGroupData[{
Cell[7143, 216, 1451, 37, 487, "Input",ExpressionUUID->"8b2bcac9-7a69-4a10-8f5b-28475aedf830"],
Cell[8597, 255, 1077, 30, 259, "Output",ExpressionUUID->"3aa25243-e5a5-46f7-8354-a31ef876e3a5"],
Cell[9677, 287, 1218, 38, 344, "Output",ExpressionUUID->"7aef8bea-8559-4c68-af23-2cd5ba7f3751"]
}, Open  ]],
Cell[10910, 328, 222, 4, 84, "Text",ExpressionUUID->"136239ce-b573-4515-addd-947e410d1ac7"],
Cell[CellGroupData[{
Cell[11157, 336, 1444, 34, 398, "Input",ExpressionUUID->"0da639f1-867b-4896-9d54-cfb1da0e590c"],
Cell[12604, 372, 887, 25, 251, "Output",ExpressionUUID->"082310a5-3641-472b-9969-b20f09757990"],
Cell[13494, 399, 1026, 33, 304, "Output",ExpressionUUID->"5e2f157f-16e9-40ac-a80c-76c7c0316383"]
}, Open  ]],
Cell[14535, 435, 298, 5, 84, "Text",ExpressionUUID->"6b4ed127-3fa1-4fcb-8b47-a903aa1aad12"],
Cell[CellGroupData[{
Cell[14858, 444, 1283, 35, 335, "Input",ExpressionUUID->"3e7e01ea-1e00-44e8-b9a2-42592e803396"],
Cell[16144, 481, 223, 3, 83, "Output",ExpressionUUID->"df52c598-8b29-4b4d-a9d4-e9502d6471b6"]
}, Open  ]],
Cell[16382, 487, 323, 5, 84, "Text",ExpressionUUID->"26eaf4a8-f1aa-4900-9842-d254d99184f6"],
Cell[CellGroupData[{
Cell[16730, 496, 1221, 31, 335, "Input",ExpressionUUID->"460613fe-d951-4ec4-85ae-0a368a9a1056"],
Cell[17954, 529, 231, 3, 83, "Output",ExpressionUUID->"cdfb30ed-f316-4894-a261-01add74cf880"]
}, Open  ]],
Cell[18200, 535, 372, 6, 84, "Text",ExpressionUUID->"399d331f-a36d-4c07-9b72-2f38b24c9ea6"],
Cell[CellGroupData[{
Cell[18597, 545, 402, 7, 282, "Input",ExpressionUUID->"9811b81d-11d0-4883-a3f1-69b2f4efddbb"],
Cell[19002, 554, 648, 15, 185, "Output",ExpressionUUID->"f0cb0176-ad39-4e54-9a39-c3901e3b91d3"],
Cell[19653, 571, 770, 22, 278, "Output",ExpressionUUID->"d8b1725e-2534-4354-9680-0c96d805f9d1"],
Cell[20426, 595, 770, 22, 278, "Output",ExpressionUUID->"9ce3d172-5267-4918-a00a-7b64a3d56f7b"]
}, Open  ]]
}
]
*)

